/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.impl2.IVWSIMEventBuffer;
import filenet.sim.appserver.IVWSIMCommand;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWTimerLog;
import java.net.InetAddress;
import simulator.ISimulator;
import simulator.util.VWSIMException;

class RetrievalThread
extends Thread {
    private static final int BATCH_SIZE = 500;
    private IVWSIMEventBuffer m_eventBuffer = null;
    private IVWSIMCommand m_cmd = null;
    private String m_scenarioID = null;
    private int m_status = 0;
    private String m_statusMsg = null;
    private String m_context = null;
    private boolean useSOAP = false;
    private ISimulator m_RMISimulator = null;
    private int m_batchSize = 500;
    protected static final Logger logger = Logger.getLogger("filenet.sim.animationdp.retrieval");
    private String m_className = "Retrieval";
    private long m_size = 0L;
    private boolean m_finished;
    private boolean bPaused = false;
    private boolean bStop = false;
    private boolean bTimedOut = false;

    protected long getSize() {
        return this.m_size;
    }

    protected boolean finished() {
        return this.m_finished;
    }

    protected int getStatus() {
        return this.m_status;
    }

    protected String getStatusMessage() {
        return this.m_statusMsg;
    }

    protected RetrievalThread(IVWSIMCommand cmd, String GUID, IVWSIMEventBuffer buf) {
        this.m_className = this.m_className + ":soap:";
        this.m_className = this.m_className + GUID;
        this.m_eventBuffer = buf;
        this.m_scenarioID = GUID;
        this.m_cmd = cmd;
        this.useSOAP = true;
    }

    protected RetrievalThread(ISimulator simServer, String GUID, IVWSIMEventBuffer buf) {
        this.m_className = this.m_className + ":rmi:";
        this.m_className = this.m_className + GUID;
        this.m_eventBuffer = buf;
        this.m_scenarioID = GUID;
        this.m_RMISimulator = simServer;
        this.useSOAP = false;
    }

    public void setBatchSize(int n) {
        if (n > 0) {
            this.m_batchSize = n;
        }
    }

    public void pause() {
        this.bPaused = true;
    }

    public void goOn() {
        this.bPaused = false;
    }

    public boolean isPaused() {
        return this.bPaused;
    }

    public void stopRetrieval() {
        if (logger.isFinest()) {
            logger.finest(this.m_className, "stopRetrieval", "called.");
        }
        this.bStop = true;
    }

    public boolean getTimedOut() {
        return this.bTimedOut;
    }

    private void getMyContext() {
        try {
            this.m_context = InetAddress.getLocalHost().getHostName() + ":" + Long.toString(System.currentTimeMillis());
        }
        catch (Exception e) {
            this.m_context = "MYHOST:" + Long.toString(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String m_method = "run";
        VWTimerLog timer = new VWTimerLog("AnimationDP Retrieval Thread");
        String batchSize = System.getProperty("filenet.sim.animationdp.retrieval.size");
        if (batchSize != null) {
            try {
                this.m_batchSize = Integer.parseInt(batchSize);
            }
            catch (Exception e) {
                this.m_batchSize = 500;
            }
        }
        this.getMyContext();
        try {
            try {}
            catch (Throwable e) {
                VWSIMException vwex;
                String causeClass;
                e.printStackTrace();
                logger.throwing(this.m_className, m_method, e);
                StringBuffer cause = new StringBuffer(e.getMessage());
                if (e instanceof VWSIMException && (causeClass = (vwex = (VWSIMException)e).getCauseClassName()) != null) {
                    cause.append(". Cause:").append(causeClass).append(", ").append(vwex.getCauseDescription());
                }
                this.m_eventBuffer.markFinished(65535, cause.toString());
                logger.fine(this.m_className, m_method, "Got exeption.." + e.getMessage());
                this.getStatusFromEventBuffer();
                Object var9_12 = null;
                timer.stop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            timer.stop();
            throw throwable;
        }
        while (!this.bStop) {
            byte[][] s;
            block21: {
                this.bTimedOut = false;
                while (this.bPaused && !this.bStop) {
                    RetrievalThread.sleep(500L);
                }
                if (this.bStop) break;
                s = null;
                try {
                    s = this.useSOAP ? this.m_cmd.readSimulationData(this.m_scenarioID, this.m_context, this.m_batchSize) : this.m_RMISimulator.readStatsData(this.m_scenarioID, this.m_context, this.m_batchSize);
                }
                catch (Throwable e) {
                    logger.warning(this.m_className, m_method, "Got exception:" + e.getClass().getName() + ", ex=" + e.toString());
                    if (e instanceof VWSIMException) {
                        String cause = ((VWSIMException)e).getCauseClassName();
                        logger.warning(this.m_className, m_method, "VWSIMException cause is :" + (cause == null ? "NULL" : cause));
                        if (cause != null && cause.equals("WhatIsTheExceptionAgain?")) {
                            this.bPaused = true;
                            this.bTimedOut = true;
                            continue;
                        }
                    }
                    throw e;
                }
                if (s == null) {
                    if (!this.useSOAP && this.m_RMISimulator != null && this.m_scenarioID != null) {
                        System.out.print(".");
                        Thread.sleep(1000L);
                        break block21;
                    } else {
                        this.m_finished = true;
                        this.m_status = 65535;
                        this.m_statusMsg = new VWString("filenet.sim.animationdp.retrieval.noData", "Error encountered during retrieval. No data was returned.").toString();
                        this.m_eventBuffer.markFinished(this.m_status, this.m_statusMsg);
                        logger.warning(this.m_className, m_method, "NO DATA!");
                        break;
                    }
                }
                this.m_size += (long)this.m_eventBuffer.log(s);
                this.getStatusFromEventBuffer();
                this.bStop = this.m_finished;
                if (this.m_finished && logger.isFinest()) {
                    logger.finest(this.m_className, m_method, this.m_statusMsg);
                }
                if (logger.isFinest()) {
                    logger.finest(this.m_className, m_method, "TOTAL=" + Long.toString(this.m_size));
                }
            }
            s = null;
        }
        Object var9_11 = null;
        timer.stop();
        if (logger.isFinest()) {
            logger.finest(this.m_className, m_method, "DONE.");
        }
    }

    private void getStatusFromEventBuffer() {
        if (this.m_eventBuffer == null) {
            return;
        }
        this.m_finished = this.m_eventBuffer.finished();
        this.m_status = this.m_eventBuffer.getStatus();
        this.m_statusMsg = this.m_eventBuffer.getStatusMessage();
    }
}

